package com.ejie.aa17a.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.Aa17aLimiteContaminante;
import com.ejie.aa17a.service.iface.Aa17aLimiteContaminanteService;

/**
 * Aa17aContaminanteController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/limitesContaminante")
public class Aa17aLimiteContaminanteController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aLimiteContaminanteController.class);

	private Aa17aLimiteContaminanteService aa17aLimiteContaminanteService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idContaminante
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{idContaminante}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aLimiteContaminante> getLimitesContaminantes(@PathVariable Long idContaminante) {
		Aa17aLimiteContaminanteController.logger.info("[GET - View] : getLimitesContaminantes ");

		Aa17aLimiteContaminante aa17aLimiteContaminante = new Aa17aLimiteContaminante();
		aa17aLimiteContaminante.setIdContaminante(idContaminante);

		return this.aa17aLimiteContaminanteService.findAll(aa17aLimiteContaminante);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idContaminante
	 *            Long
	 * @param tipoLimite
	 *            Integer
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aLimiteContaminante> getLimitesContaminantesHistorico(@RequestParam Long idContaminante, @RequestParam Integer tipoLimite) {
		Aa17aLimiteContaminanteController.logger.info("[GET - View] : getLimitesContaminantes ");

		Aa17aLimiteContaminante aa17aLimiteContaminante = new Aa17aLimiteContaminante();
		aa17aLimiteContaminante.setIdContaminante(idContaminante);
		aa17aLimiteContaminante.setTipoLimite(tipoLimite);

		return this.aa17aLimiteContaminanteService.findAll(aa17aLimiteContaminante);
	}

	/**
	 * @param aa17aLimiteContaminanteService
	 *            the aa17aLimiteContaminanteService to set
	 */
	public void setAa17aLimiteContaminanteService(Aa17aLimiteContaminanteService aa17aLimiteContaminanteService) {
		this.aa17aLimiteContaminanteService = aa17aLimiteContaminanteService;
	}

}
